/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8271k;

import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.MessageDestination;
import ibm.nways.jdm.NavFieldOverride;
import ibm.nways.jdm.NavigationBrowser;
import ibm.nways.jdm.NavigationBrowserEventListener;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.NavigationFolder;
import ibm.nways.jdm.NavigationItem;
import ibm.nways.jdm.NavigationPoint;
import ibm.nways.jdm.browser.Browser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmContext;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import ibm.nways.jdm8271k.BoxInfo;
import ibm.nways.jdm8271k.eui.ConfigurationAltFolderGroup;
import ibm.nways.jdm8271k.eui.ConfigurationFolderGroup;
import ibm.nways.jdm8271k.eui.FaultBaseGroup;
import ibm.nways.jdm8271k.eui.SecurityBaseGroup;
import ibm.nways.ras.RAS;
import ibm.nways.telnet.TelnetContext;
import ibm.nways.web.WebContext;
import java.util.ResourceBundle;

public class Jdm8271k
extends JdmBrowser {
    private static final int RASID = 19;
    private static final int RASSUB = 21;
    private NavFieldOverride navFieldOverrides;
    static final Object[][] fieldOverrideConstants = new Object[][]{{"ibm.nways.bridge.eui.BridgePortsPanel.sourcerouteports.visible", "false"}};
    private static String bundleName = "ibm.nways.jdm8271k.GeneralResources";
    private static String RootFolderTitle = "RootFolderTitle";
    private static String ToolsFolderTitle = "ToolsFolderTitle";
    private static String MibBrowserTitle = "MibBrowserTitle";
    private static String StartGraphic = "StartGraphic";
    private static String EndGraphic = "EndGraphic";
    private static String StartNavTree = "StartNavTree";
    private static String EndNavTree = "EndNavTree";
    private ResourceBundle myResources;
    private NavigationFolder rootFolder;
    private NavigationBrowser tree;
    private NavigationContext navContext;
    private GenModel deviceModel;
    BoxInfo boxInfo;
    boolean deviceResponding;
    private GraphicPanel deviceGraphicPanel;

    public String getModelTypeName() {
        return "ibm.nways.jdm8271k.model.Jdm8271k";
    }

    public GraphicPanel getDeviceGraphicPanel() {
        this.boxInfo = new BoxInfo(this.deviceModel, this);
        this.navContext = this.rootFolder.getNavContext();
        if (this.navContext != null) {
            this.boxInfo.setLaunchData(this.navContext);
        }
        GraphicPanel graphicPanel = null;
        if (RAS.isEnabled(19, 21)) {
            RAS.trace(19, 21, (Object)this, "getDeviceGraphicPanel", "Entering");
        }
        this.displayMsg(this.myResources.getString(StartGraphic));
        graphicPanel = this.boxInfo.getDeviceGraphic();
        this.displayMsg(this.myResources.getString(EndGraphic));
        if (RAS.isEnabled(19, 21)) {
            RAS.trace(19, 21, (Object)this, "getDeviceGraphicPanel", "Exiting");
        }
        return graphicPanel;
    }

    protected NavigationPoint getNavTreeRoot() {
        if (RAS.isEnabled(19, 21)) {
            RAS.trace(19, 21, (Object)this, "getNavTreeRoot", "Entering");
        }
        if (this.myResources == null) {
            this.myResources = ResourceBundle.getBundle(bundleName);
        }
        this.rootFolder = new NavigationFolder(this.myResources.getString(RootFolderTitle));
        this.navContext = this.rootFolder.getNavContext();
        this.deviceModel = (GenModel)this.getModel();
        this.navFieldOverrides = new NavFieldOverride(this.navContext, fieldOverrideConstants);
        if (RAS.isEnabled(19, 21)) {
            RAS.trace(19, 21, (Object)this, "getNavTreeRoot", "Exiting");
        }
        return this.rootFolder;
    }

    protected void getRestOfNavTree() {
        if (RAS.isEnabled(19, 21)) {
            RAS.trace(19, 21, (Object)this, "getRestOfNavTree", "Entering");
        }
        this.displayMsg(this.myResources.getString(StartNavTree));
        this.deviceResponding = this.boxInfo.getDeviceStatus() == 1;
        this.tree = this.getNavigationBrowser();
        this.navContext.put((Object)"TREE", (Object)this.tree);
        if (this.deviceModel != null && this.deviceResponding) {
            this.buildConfigurationFolder(this.rootFolder, false);
            this.buildFaultFolder(this.rootFolder);
            this.buildSecurityFolder(this.rootFolder);
            this.buildToolsFolder(this.rootFolder);
        } else {
            this.buildConfigurationFolder(this.rootFolder, true);
            this.buildToolsFolder(this.rootFolder);
        }
        this.displayMsg(this.myResources.getString(EndNavTree));
        if (RAS.isEnabled(19, 21)) {
            RAS.trace(19, 21, (Object)this, "getRestOfNavTree", "Exiting");
        }
    }

    private void buildConfigurationFolder(NavigationFolder navigationFolder, boolean bl) {
        GenModel genModel = null;
        try {
            ConfigurationAltFolderGroup configurationAltFolderGroup;
            if (bl) {
                genModel = (GenModel)this.deviceModel.getComponent("ConfigurationAltFolder");
                configurationAltFolderGroup = new ConfigurationAltFolderGroup((JdmBrowser)this, genModel);
                configurationAltFolderGroup.setIsInitiallyExpanded(false);
                this.tree.addEventListener((NavigationBrowserEventListener)configurationAltFolderGroup);
            } else {
                genModel = (GenModel)this.deviceModel.getComponent("ConfigurationFolder");
                configurationAltFolderGroup = new ConfigurationFolderGroup((JdmBrowser)this, genModel);
                configurationAltFolderGroup.setIsInitiallyExpanded(false);
                this.tree.addEventListener((NavigationBrowserEventListener)((ConfigurationFolderGroup)configurationAltFolderGroup));
            }
            navigationFolder.add((NavigationPoint)configurationAltFolderGroup);
            return;
        }
        catch (Exception exception) {
            RAS.logError(19, 21, (Object)this, "buildConfigurationFolder", "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"ConfigurationFolder", (Object)"Jdm8271kModel");
            RAS.logException(19, 21, (Object)this, "buildConfigurationFolder", exception);
            return;
        }
    }

    private void buildFaultFolder(NavigationFolder navigationFolder) {
        GenModel genModel = null;
        try {
            genModel = (GenModel)this.deviceModel.getComponent("Fault");
        }
        catch (Exception exception) {
            RAS.logError(19, 21, (Object)this, "buildFaultFolder", "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"Fault", (Object)"Jdm8271kModel");
            RAS.logException(19, 21, (Object)this, "buildFaultFolder", exception);
        }
        if (genModel != null) {
            FaultBaseGroup faultBaseGroup = new FaultBaseGroup((JdmBrowser)this, genModel);
            faultBaseGroup.setIsInitiallyExpanded(false);
            this.tree.addEventListener((NavigationBrowserEventListener)faultBaseGroup);
            navigationFolder.add((NavigationPoint)faultBaseGroup);
            return;
        }
        navigationFolder.add((NavigationPoint)new NavigationItem(this.myResources.getString("Fault"), (NavigationDestination)new MessageDestination(this.myResources.getString("NotConfigured"))));
    }

    private void buildSecurityFolder(NavigationFolder navigationFolder) {
        GenModel genModel = null;
        try {
            genModel = (GenModel)this.deviceModel.getComponent("Security");
        }
        catch (Exception exception) {
            RAS.logError(19, 21, (Object)this, "buildSecurityFolder", "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"Security", (Object)"Jdm8271kModel");
            RAS.logException(19, 21, (Object)this, "buildSecurityFolder", exception);
        }
        if (genModel != null) {
            SecurityBaseGroup securityBaseGroup = new SecurityBaseGroup((JdmBrowser)this, genModel);
            securityBaseGroup.setIsInitiallyExpanded(false);
            this.tree.addEventListener((NavigationBrowserEventListener)securityBaseGroup);
            navigationFolder.add((NavigationPoint)securityBaseGroup);
            return;
        }
        navigationFolder.add((NavigationPoint)new NavigationItem(this.myResources.getString("Security"), (NavigationDestination)new MessageDestination(this.myResources.getString("NotConfigured"))));
    }

    private void buildToolsFolder(NavigationFolder navigationFolder) {
        NavigationFolder navigationFolder2 = null;
        navigationFolder2 = new NavigationFolder(this.myResources.getString(ToolsFolderTitle));
        navigationFolder2.setDestination(new NavigationDestination("ibm.nways.jdm.NilDestination", null));
        navigationFolder2.setIsInitiallyExpanded(true);
        navigationFolder.add((NavigationPoint)navigationFolder2);
        try {
            SnmpContextModel snmpContextModel = (SnmpContextModel)this.deviceModel.getComponent("_ContextInfo");
            ModelInfo modelInfo = snmpContextModel.getConfig();
            String string = modelInfo.get("Config.Address").toString();
            ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.telnet.TelnetPanelResources");
            TelnetContext telnetContext = new TelnetContext(string, "-e vt100");
            NavigationItem navigationItem = new NavigationItem(resourceBundle.getString("TelnetPanelTitle"), new NavigationDestination("ibm.nways.telnet.TelnetPanel", null), "Telnet");
            NavigationContext navigationContext = navigationItem.getNavContext();
            navigationContext.put((Object)"telnetContext", (Object)telnetContext);
            navigationFolder2.add((NavigationPoint)navigationItem);
            NavigationBrowser navigationBrowser = this.getNavigationBrowser();
            Browser browser = new Browser(this.myResources.getString(MibBrowserTitle), (JdmBrowser)this, snmpContextModel);
            navigationBrowser.addEventListener((NavigationBrowserEventListener)browser);
            navigationFolder2.add((NavigationPoint)browser.getRootFolder());
            ResourceBundle resourceBundle2 = ResourceBundle.getBundle("ibm.nways.web.Resources");
            WebContext webContext = new WebContext(string);
            webContext.only_nhd_url();
            NavigationItem navigationItem2 = new NavigationItem(resourceBundle2.getString("weblaunch"), new NavigationDestination("ibm.nways.web.WebBrowserPanel", null), "WebBrowser");
            navigationContext = navigationItem2.getNavContext();
            navigationContext.put((Object)"webContext", (Object)webContext);
            navigationFolder2.add((NavigationPoint)navigationItem2);
            if (this.getIsApplication()) {
                AnalyzerJdmContext analyzerJdmContext = new AnalyzerJdmContext(string, this.getServerPortNumber());
                NavigationItem navigationItem3 = new NavigationItem(AnalyzerJdmPanel.getTitle(), new NavigationDestination("ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel", null), "Analyzer");
                navigationContext = navigationItem3.getNavContext();
                navigationContext.put((Object)"analyzerJdmContext", (Object)analyzerJdmContext);
                navigationFolder2.add((NavigationPoint)navigationItem3);
                return;
            }
        }
        catch (Exception exception) {
            RAS.logError(19, 21, (Object)this, "buildToolsFolder", "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"_ContextInfo", (Object)"SnmpContextModel");
            RAS.logException(19, 21, (Object)this, "buildToolsFolder", exception);
        }
    }
}

